<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $tenant = app('tenant');
        $settings = Setting::firstOrCreate(['tenant_id' => $tenant->id], [
            'company_name' => '',
            'number' => '',
            'address' => '',
            'company_registration_number' => '',
            'company_email' => '',
            'website' => '',
            'time_zone' => 'Asia/Dhaka',
            'currency' => 'USD',
            'logo_path' => null,
            'pos_price_type' => 'fixed',
            'pos_price_value' => 0.00,
            'tenant_id' => $tenant->id,
        ]);

        return view('settings.index', compact('settings'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Setting $setting)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Setting $setting)
    {
        $tenant = app('tenant');
        $settings = Setting::firstOrCreate(['tenant_id' => $tenant->id], [
            'company_name' => '',
            'number' => '',
            'address' => '',
            'company_registration_number' => '',
            'company_email' => '',
            'website' => '',
            'time_zone' => 'Asia/Dhaka',
            'currency' => 'USD',
            'logo_path' => null,
            'pos_price_type' => 'fixed',
            'pos_price_value' => 0.00,
            'tenant_id' => $tenant->id,
        ]);

        return view('settings.edit', compact('settings'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Setting $setting)
    {
        $request->validate([
            'company_name' => 'required|string|max:255',
            'company_registration_name' => 'nullable|string|max:255',
            'number' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'company_registration_number' => 'required|string|max:255',
            'company_email' => 'required|email|max:255',
            'website' => 'required|url|max:255',
            'time_zone' => 'required|string',
            'currency' => 'required|string',
            'logo_path' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'pos_price_type' => 'required|in:fixed,percentage',
            'pos_price_value' => 'required|numeric|min:0',
        ]);
    
        // Get existing settings
        $settings = Setting::first();
        if (!$settings) {
            return redirect()->back()->with('error', 'Settings not found.');
        }
    
        // Handle file upload
        if ($request->hasFile('logo_path')) {
            // Define upload path
            $uploadPath = public_path('logos'); // Store in public/logos folder
    
            // Ensure directory exists
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }
    
            // Delete old logo if exists
            if (!empty($settings->logo_path) && file_exists(public_path('logos/' . $settings->logo_path))) {
                unlink(public_path('logos/' . $settings->logo_path));
            }
    
            // Generate a unique filename
            $filename = time() . '.' . $request->file('logo_path')->extension();
    
            // Move the file to the public folder
            $request->file('logo_path')->move($uploadPath, $filename);
    
            // Update logo path in DB
            $settings->logo_path = $filename;
        }
    
        // Update settings
        $settings->update([
            'company_name' => $request->company_name,
            'company_registration_name' => $request->company_registration_name,
            'number' => $request->number,
            'address' => $request->address,
            'company_registration_number' => $request->company_registration_number,
            'company_email' => $request->company_email,
            'website' => $request->website,
            'time_zone' => $request->time_zone,
            'currency' => $request->currency,
            'pos_price_type' => $request->pos_price_type,
            'pos_price_value' => $request->pos_price_value,
        ]);
    
        return redirect()->route('settings.index')->with('success', 'Company settings updated successfully.');
    }

    
}